<?php

$data = implode("\n", $_POST);

$domain = $_SERVER['HTTP_HOST'];
$to = "lead@".$domain; 
$subject = "Lead";
$message = $data;
$headers = "From: sender@".$domain;

if(mail($to, $subject, $message, $headers)) {
    //echo "Письмо успешно отправлено!";
}

?>


<!DOCTYPE html>
<html>
  <head>
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <link href="https://fonts.googleapis.com/css2?family=Radio+Canada+Big:ital,wght@0,400..700;1,400..700&display=swap" rel="stylesheet" />
    <title>Stratexavc - Request accepted!</title>
    <meta property="og:title" content="Stratexavc - Request accepted!" />
    <meta property="og:image" content="brand-identity.svg" />
    
    <meta property="og:description" content="Stratexavc - Request accepted!" />
    <meta name="description" content="Stratexavc - Request accepted!" />
    <link rel="shortcut icon" href="{logo_img}" type="image/x-icon" />
    

    <style>
      * {
        box-sizing: border-box;
      }

      html {
        box-sizing: border-box;
      	scroll-behavior: smooth;
      }

       body{
        background-color: #f2f2f2;
      	direction: ltr;
      	font-family: 'Comme', sans-serif !important;
      	font-size: 17px;
      	margin: 0;
      	padding: 0px;
      	line-height: 1.5;
      }

      h1,
      h2,
      h3,
      h4,
      h5,
      p{
      	padding: 0;
      	margin: 0;
      }

      p, li{
        padding: 5px 0;
        line-height: 1.5;
      }

      li{
        margin: 0 8px;
      }

      a{
      	text-decoration: none;
      	color: inherit;
      	cursor: pointer;
      }

      img{
      	display: block;
      	max-width: 100%;
      	max-height: 100%;
      }

      ul{
      	margin: 0;
      	padding: 0;
      }

      .page-privacy{
       word-break: break-all;
        background-color: #fff;
        overflow: hidden;
        text-align: justify;
        margin: 48px 0;
        padding: 25px;
      }

      .page-privacy a{
        color: #000;
      }

      .page-privacy a:hover{
        color: #000;
        opacity: 0.5;
      }

      .container-block{
        width: auto;
        padding-right: 19px;
        padding-left: 19px;
        margin-right: auto;
        margin-left: auto;
        position: relative;
      }

      @media screen and (min-width: 480px) {
        .container-block{
        max-width: 450px;
        }
      }
      @media screen and (min-width: 575px){
        .container-block{
          max-width: 540px;
        }
      }
      @media screen and (min-width: 768px) {
        .container-block{
        max-width: 730px;
        }
      }
      @media screen and (min-width: 992px) {
        .container-block{
          max-width: 960px;
        }
      }

      @media screen and (min-width: 1200px){
        .container-block{
          max-width: 1170px;
          }
      }

      @media (min-width: 1400px){
        .container-block{
          max-width: 1274px;
        }
      }

      .fixed-header {
        box-shadow: rgba(100, 100, 111, 0.2) 0px 7px 29px 0px;
        position: fixed;
        top: 0;
        left: 0;
        right: 0;
        z-index: 99;
        transition: top 0.3s ease;
      }

      .header-lay{
        box-shadow: rgba(100, 100, 111, 0.2) 0px 7px 29px 0px;
        background-color: #fff;
      }

      .header{
        display: flex;
        flex-direction: row;
        align-items: center;
        justify-content: space-between;
        padding: 14px 0;
        gap: 29px;
      }

      .logo {
        color: #000;
        display: flex;
        align-items: center;
        gap: 17px;
      }

      .logoImg{
        max-width: 48px;
        max-height: 48px;
      }

      .logoImg img{
        object-fit: contain;
        width: 100%;
        height: 100%;
      }

      .logoTitle .logoTitle-text{
        transition: 0.3s ease;
        font-size: 17px;
        margin: 0;
      }

      .logoTitle .logoTitle-text:hover{
        opacity: 0.5;
      }

      .header-nav{
        display: flex;
        flex-direction: row;
        align-items: center;
        gap: 14px;
      }

      .header-nav ul{
        display: flex;
        flex-direction: row;
        align-items: center;
        gap: 14px;
        list-style: none;
      }

      .header-nav ul li{
        font-size: clamp(12px, 4vw, 18px);
      }

      .header-nav ul li a{
        transition: 0.3s ease;
      }

      .header-nav ul li a:hover{
        opacity: 0.5;
      }

      .header-content{
        padding: 48px 0;
        display: flex;
        flex-direction: row;
      }

      .main-news{
        transition: 0.5s ease;
        position: relative;
        flex: 2;
      }

      .main-news img{
        object-fit: cover;
        transition: 0.5s ease;
        filter: brightness(50%);
        width: 100%;
        height: 100%;
        position: relative;
      }

      .main-news:hover img{
        filter: brightness(30%);
      }

      .main-news-text {
        display: flex;
        flex-direction: column;
        align-items: start;
        gap: 5px;
        position: absolute;
        bottom: 0;
        left: 0;
        padding: 14px;
      }

      .main-news-text h5{
        background-color: #f39189;
        padding: 0 1.5rem;
        color: #fff;
      }

      .main-news-text h2{
        display: -webkit-box;
        -webkit-box-orient: vertical;
        overflow: hidden;
        -webkit-line-clamp: 3;
        font-size: clamp(12px, 4vw, 18px);
        color: #fff;
      }

      .main-news-text p{
        font-size: clamp(12px, 4vw, 14px);
        color: rgba(255, 255, 255, 0.5);
      }

      .news-box{
        display: flex;
        flex-direction: column-reverse;
        flex: 1;
      }

      .news-card{
        flex: 1;
        transition: 0.5s ease;
        position: relative;
      }

      .news-card img{
        object-fit: cover;
        transition: 0.5s ease;
        filter: brightness(50%);
        width: 100%;
        height: 100%;
        position: relative;
      }

      .news-card:hover img{
        filter: brightness(30%);
      }

      .news-card-text{
        display: flex;
        flex-direction: column;
        align-items: start;
        gap: 5px;
        position: absolute;
        bottom: 0;
        left: 0;
        padding: 14px;
      }

      .news-card-text h5{
        background-color: #257A3E;
        padding: 0 1.5rem;
        color: #fff;
      }

      .news-card-text h2{
        display: -webkit-box;
        -webkit-box-orient: vertical;
        overflow: hidden;
        -webkit-line-clamp: 3;
        font-size: clamp(12px, 4vw, 18px);
        color: #fff;
      }

      .news-card-text p{
        font-size: clamp(12px, 4vw, 14px);
        color: rgba(255, 255, 255, 0.5);
      }

      .greetings{
        background-color: #fff;
        display: flex;
        gap: 29px;
        align-items: center;
        justify-content: center;
        flex-direction: column;
        padding: 25px;
      }

      .greetings svg{
        width: 73px;
        height: 73px;
        color: #cccccc;
      }

      .greetings h2{
        font-weight: 500;
        font-size: clamp(12px, 4vw, 18px);
        color: #000;
        text-align: center;
      }

      .popular-stats{
        display: grid;
        gap: 29px;
        grid-template-columns: repeat(3, 1fr);
        padding: 48px 0;
      }

      .popular-stats-card{
        transition: 0.5s ease;
        display: flex;
        flex-direction: column;
      }

      .popular-stats-box{
        position: relative;
      }

      .popular-stats-box img{
        transition: 0.5s ease;
        position: relative;
        width: 100%;
        height: 294px;
        object-fit: cover;
      }

      .popular-stats-card:hover .popular-stats-box img{
        filter: brightness(50%);
      }

      .popular-stats-box h5{
        margin: 5px;
        background-color: #257A3E;
        padding: 0 1.5rem;
        color: #fff;
        position: absolute;
        bottom: 0;
        left: 0;
      }

      .popular-stats-card p{
        font-weight: 500;
        display: flex;
        align-items: center;
        justify-content: center;
        flex: 1;
        text-align: center;
        background-color: #fff;
        padding: 14px;
        color: #000;
      }

      .art{
        margin: 48px 0;
        background-color: #fff;
        padding: 48px;
      }

      .titleArt {
        font-size: 18px;
        text-transform: uppercase;
        letter-spacing: 2px;
        text-align: center;
        font-weight: bold;
        margin-bottom: 48px;
      }

      .picture-art-img {
        float: left;
        width: 38%;
        margin: 48px;
        margin-top: 0;
        margin-left: 0;
      }

      .art-content{
        color: #000;
        opacity: 0.8;
      }

      .art-price {
        text-transform: uppercase;
        letter-spacing: 2px;
        color: #2A2438;
        text-align: center;
        font-size: 25px;
        padding-top: 48px;
        font-weight: bold;
      }

      .art-other{
        padding-top: 48px;
        display: flex;
        align-items: center;
        justify-content: space-between;
        gap: 29px;
        flex-direction: row;
      }

      .art-other-tag{
        display: flex;
        align-items: center;
        justify-content: space-between;
        gap: 14px;
        flex-direction: row;
      }

      .art-other-tag p{
        margin: 0;
        color: #888;
        border: 1px solid #888;
        padding: 5px;
      }

      .art-other-watch p{
        margin: 0;
        display: flex;
        flex-direction: row;
        align-items: center;
        color: #888;
        font-size: 17px;
        gap: 14px;
      }

      .art-other-watch svg{
        color: #888;
        width: 17px;
        height: 17px;
      }

      .phone-but{
        text-align: center;
        display: flex;
        justify-content: center;
        border-top: 0.1px solid #888;
        padding-top: 48px;
        margin-top: 48px;
      }

      .osn-form {
        border-top: 0.1px solid #888;
        margin-top: 48px;
        padding-top: 48px;
        background-color: white;
        display: flex;
        flex-direction: column;
      }

      .title-container{
        margin-bottom: 29px;
        text-align: center;
      }

      .title-container h3{
        margin: 0;
        font-weight: bold;
      }

      .input-container {
        display: flex;
        flex-direction: column;
        position: relative;
      }

      .input-container .input-formpanel-item, .input-container .textarea-formpanel-item, .form button {
        outline: none;
        margin: 8px 0;
      }

      .input-container .input-formpanel-item {
        line-height: 28px;
        border: 2px solid transparent;
        border-bottom-color: #777;
        padding: 0.8em;;
        outline: none;
        background-color: transparent;
        color: #0d0c22;
        transition: .3s cubic-bezier(0.645, 0.045, 0.355, 1);
      }

      .input-container .textarea-formpanel-item {
        resize: vertical;
        line-height: 28px;
        border: 2px solid transparent;
        border-bottom-color: #777;
        padding: 0.8em;
        outline: none;
        background-color: transparent;
        color: #0d0c22;
        transition: .3s cubic-bezier(0.645, 0.045, 0.355, 1);
        min-height: 48px;
        max-height: 115px;
      }

      .input-container .input-formpanel-item:hover, .input-container .input-formpanel-item:focus, .input-container .textarea-formpanel-item:hover, .input-container .textarea-formpanel-item:focus{
        outline: none;
        border-radius: 1rem;
        border-color: #7a9cc6;
      }

      .check{
        transition: 0.3s ease;
        color: #000;
      }

      .check:hover{
        color: #000;
        opacity: 0.5;
      }

      .form-check {
        display: flex;
        align-items: center;
        gap: 14px;
        justify-content: flex-start;
        padding: 15px 0;
      }

      .form-check .form-check-input{
        margin: 0;
      }

      .form-check-label{
        flex: 1;
      }

      .submit-form {
        margin: 0 auto !important;
      }

      .ui-checkbox {
        --primary-color: #1677ff;
        --secondary-color: #fff;
        --primary-hover-color: #4096ff;
        --checkbox-diameter: 20px;
        --checkbox-border-radius: 5px;
        --checkbox-border-color: #d9d9d9;
        --checkbox-border-width: 1px;
        --checkbox-border-style: solid;
        --checkmark-size: 1.2;
      }

      .ui-checkbox,
      .ui-checkbox *,
      .ui-checkbox *::before,
      .ui-checkbox *::after {
        -webkit-box-sizing: border-box;
        box-sizing: border-box;
      }

      .ui-checkbox {
        -webkit-appearance: none;
        -moz-appearance: none;
        appearance: none;
        width: var(--checkbox-diameter);
        height: var(--checkbox-diameter);
        border-radius: var(--checkbox-border-radius);
        background: var(--secondary-color);
        border: var(--checkbox-border-width) var(--checkbox-border-style) var(--checkbox-border-color);
        -webkit-transition: all 0.3s;
        -o-transition: all 0.3s;
        transition: all 0.3s;
        cursor: pointer;
        position: relative;
      }

      .ui-checkbox::after {
        content: "";
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        -webkit-box-shadow: 0 0 0 calc(var(--checkbox-diameter) / 2.5) var(--primary-color);
        box-shadow: 0 0 0 calc(var(--checkbox-diameter) / 2.5) var(--primary-color);
        border-radius: inherit;
        opacity: 0;
        -webkit-transition: all 0.5s cubic-bezier(0.12, 0.4, 0.29, 1.46);
        -o-transition: all 0.5s cubic-bezier(0.12, 0.4, 0.29, 1.46);
        transition: all 0.5s cubic-bezier(0.12, 0.4, 0.29, 1.46);
      }

      .ui-checkbox::before {
        top: 40%;
        left: 50%;
        content: "";
        position: absolute;
        width: 4px;
        height: 7px;
        border-right: 2px solid var(--secondary-color);
        border-bottom: 2px solid var(--secondary-color);
        -webkit-transform: translate(-50%, -50%) rotate(45deg) scale(0);
        -ms-transform: translate(-50%, -50%) rotate(45deg) scale(0);
        transform: translate(-50%, -50%) rotate(45deg) scale(0);
        opacity: 0;
        -webkit-transition: all 0.1s cubic-bezier(0.71, -0.46, 0.88, 0.6),opacity 0.1s;
        -o-transition: all 0.1s cubic-bezier(0.71, -0.46, 0.88, 0.6),opacity 0.1s;
        transition: all 0.1s cubic-bezier(0.71, -0.46, 0.88, 0.6),opacity 0.1s;
      }

      .ui-checkbox:hover {
        border-color: var(--primary-color);
      }

      .ui-checkbox:checked {
        background: var(--primary-color);
        border-color: transparent;
      }

      .ui-checkbox:checked::before {
        opacity: 1;
        -webkit-transform: translate(-50%, -50%) rotate(45deg) scale(var(--checkmark-size));
        -ms-transform: translate(-50%, -50%) rotate(45deg) scale(var(--checkmark-size));
        transform: translate(-50%, -50%) rotate(45deg) scale(var(--checkmark-size));
        -webkit-transition: all 0.2s cubic-bezier(0.12, 0.4, 0.29, 1.46) 0.1s;
        -o-transition: all 0.2s cubic-bezier(0.12, 0.4, 0.29, 1.46) 0.1s;
        transition: all 0.2s cubic-bezier(0.12, 0.4, 0.29, 1.46) 0.1s;
      }

      .ui-checkbox:active:not(:checked)::after {
        -webkit-transition: none;
        -o-transition: none;
        -webkit-box-shadow: none;
        box-shadow: none;
        transition: none;
        opacity: 1;
      }

      .contacts-block{
        padding: 48px 0;
        display: flex;
        gap: 48px;
        justify-content: space-between;
        flex-direction: row;
      }

      .about-me{
        flex: 1;
        background-color: #fff;
        padding: 25px;
      }

      .about-me h2{
        color: #000;
        text-align: center;
        margin-bottom: 29px;
      }
      .about-me-box{
        display: flex;
        flex-direction: column;
        align-items: center;
        text-align: center;
        gap: 14px;
      }

      .about-me-box img{
        width: 210px;
        height: 210px;
        border-radius: 50%;
      }

      .about-me-box h5{
        font-size: 17px;
        color: #000;
      }

      .about-me-box p{
        color: #000;
        opacity: 0.8;
      }

      .contacts{
        background-color: #fff;
        padding: 25px;
        flex: 2;
      }

      .contacts h2{
        color: #000;
        text-align: center;
        margin-bottom: 29px;
      }

      .contacts-box{
        display: flex;
        flex-direction: column;
        gap: 14px;
      }

      .contacts-card a{
        display: flex;
        flex-direction: row;
        align-items: center;
        gap: 5px;
      }

      .contacts-card svg{
        width: 17px;
        height: 17px;
        color: #000;
      }

      .contacts-card a h5{
        font-weight: 500;
        color: #000;
        font-size: 17px;
        transition: 0.3s ease;
      }

      .contacts-card a h5:hover{
        color: #000;
        opacity: 0.5;
      }

      .contacts-card h5{
        font-weight: 500;
        color: #000;
        font-size: 17px;
      }

      .footer-lay{
        position: relative;
        width: 100%;
        box-shadow: rgba(100, 100, 111, 0.2) 0px 7px 29px 0px;
        background-color: #fff;
      }

      .footer{
        padding: 29px 0;
      }

      .footer-privacy{
        display: flex;
        justify-content: space-between;
        flex-direction: row;
        align-items: center;
        gap: 25px;
      }

      .footer-privacy p{
        color: #000;
        font-size: 17px;
      }

      .privacy{
        display: flex;
        align-items: center;
        flex-wrap: wrap;
        justify-content: center;
        gap: 29px;
        flex-direction: row;
      }

      .privacy a{
        transition: 0.3s ease;
        color: #000;
        font-size: 17px;
      }

      .privacy a:hover{
        color: #000;
        opacity: 0.5;
      }

      .gallery {
        padding: 48px 0;
        width: 100%;
        display: grid;
        grid-template-columns: repeat(4,1fr);
        grid-auto-rows: 200px;
        gap: 0.25rem;

        & img {
          width: 100%;
          height: 100%;
          object-fit: cover;

          &:not(.hero) { cursor: pointer; }
        }

        & .hero {
          grid-column: span 2;
          grid-row: span 2;
        }
      }

      @media (width < 700px) {
        .gallery {
          grid-template-columns: repeat(2,1fr);
          grid-auto-rows: 175px;
        }
      }

      .but,
      button {
        outline: none;
        border: none;
        background: inherit;
        padding: 10px;
        box-sizing: border-box !important;
      }
      .button-1 {
        background-color: #ea4c89;
        border-radius: 8px;
        border-style: none;
        box-sizing: border-box;
        color: #ffffff;
        cursor: pointer;
        display: inline-block;
        font-size: 16px;
        font-weight: 500;
        line-height: 20px;
        list-style: none;
        margin: 0;
        outline: none;
        padding: 10px 16px;
        position: relative;
        text-align: center;
        text-decoration: none;
        transition: color 100ms;
        vertical-align: baseline;
        user-select: none;
        -webkit-user-select: none;
        touch-action: manipulation;
      }

      .button-1:hover,
      .button-1:focus {
        background-color: #f082ac;
        color: #fff;
      }

      .button-2 {
        font-size: 15px;
        font-weight: bold;
        border: 0px;
        color: white;
        background-color: #1877f2;
        padding: 15px 20px;
        border-radius: 15px;
        cursor: pointer;
      }

      .button-2:hover {
        background-image: linear-gradient(90deg, #a597c4 0%, #acbcff 50%, #aee2ff 75%, #e6fffd 100%);
        color: black;
        animation: slide 10s linear infinite;
      }

      @keyframes slide {
        100% {
          background-position: 50rem;
        }
      }

      .button-3 {
        font-size: 15px;
        --bg: #000;
        --hover-bg: #e7143f;
        --hover-text: #000;
        color: #fff;
        border: 1px solid var(--bg);
        border-radius: 4px;
        padding: 1em 2em;
        background: lightsalmon;
        transition: 0.2s;
      }

      .button-3:hover {
        color: var(--hover-text);
        transform: translate(-0.25rem, -0.25rem);
        background: var(--hover-bg);
        box-shadow: 0.25rem 0.25rem var(--bg);
      }

      .button-3:active {
        transform: translate(0);
        box-shadow: none;
      }
      .button-4 {
        padding: 15px 30px;
        text-align: center;
        transition: 0.5s;
        background-size: 200% auto;
        color: white;
        border-radius: 10px;
        display: block;
        border: 0px;
        font-weight: 700;
        box-shadow: 0px 0px 14px -7px #f09819;
        background-image: linear-gradient(45deg, #ff512f 0%, #f09819 51%, #ff512f 100%);
        cursor: pointer;
        user-select: none;
        -webkit-user-select: none;
        touch-action: manipulation;
      }

      .button-4:hover {
        background-position: right center;
        color: #fff;
        text-decoration: none;
      }

      .button-4:active {
        transform: scale(0.95);
      }
      .button-5 {
        align-items: center;
        background-color: #0a66c2;
        border: 0;
        border-radius: 100px;
        box-sizing: border-box;
        color: #ffffff;
        cursor: pointer;
        display: inline-flex;
        font-size: 16px;
        font-weight: 600;
        justify-content: center;
        line-height: 20px;
        max-width: 480px;
        min-height: 40px;
        min-width: 0px;
        overflow: hidden;
        padding: 10px;
        text-align: center;
        touch-action: manipulation;
        transition: background-color 0.167s cubic-bezier(0.4, 0, 0.2, 1) 0s,
          box-shadow 0.167s cubic-bezier(0.4, 0, 0.2, 1) 0s, color 0.167s cubic-bezier(0.4, 0, 0.2, 1) 0s;
        user-select: none;
        -webkit-user-select: none;
        vertical-align: middle;
      }

      .button-5:hover,
      .button-5:focus {
        background-color: #16437e;
        color: #ffffff;
      }

      .button-5:active {
        background: #09223b;
        color: rgb(255, 255, 255, 0.7);
      }

      .button-5:disabled {
        cursor: not-allowed;
        background: rgba(0, 0, 0, 0.08);
        color: rgba(0, 0, 0, 0.3);
      }

      @media (max-width: 991px) {
        .header-content{
          flex-direction: column-reverse;
        }

        .news-box{
          flex-direction: row;
        }

        .popular-stats{
          grid-template-columns: repeat(2, 1fr);
        }

        .contacts-block{
          flex-direction: column-reverse;
        }

        .footer-privacy{
          text-align: center;
          flex-direction: column;
        }
      }

      @media (max-width: 767px) {
        .header{
          flex-direction: column;
        }

        .header-nav ul{
          flex-wrap: wrap;
          justify-content: center;
        }

        .news-card:last-child{
          display: none;
        }

        .popular-stats{
          grid-template-columns: repeat(1, 1fr);
        }

        .picture-art-img{
          width: 100%;
          margin: 0 0 48px 0;
        }

        .art-other{
          flex-direction: column-reverse;
        }

        .art-other-tag{
          flex-wrap: wrap;
          justify-content: center;
        }

        .art{
          padding: 17px;
        }

        .greetings{
          padding: 17px;
        }

        .contacts{
          padding: 17px;
        }

        .about-me{
          padding: 17px;
        }

        .art-price{
          text-align: center;
          font-size: 18px;
        }

        .title-politics{
          font-size: 18px;
        }

        .page-privacy{
          padding: 17px;
        }
      }

      @media (max-width: 575px) {
        .contacts-card{
          overflow: auto;
        }

        .contacts-card a{
          flex-wrap: wrap;
        }
      }
    </style>

    
  </head>

  <body>
    <div class="header-lay wrapperst-style">
      <div class="container-block">
        <div class="header">
          <a class="logo" href="./">
            <div class="logoImg"><img src="brand-identity.svg" alt="" /></div>
            <div class="logoTitle"><h2 class="logoTitle-text">Stratexavc</h2></div>
          </a>
          <nav class="header-nav">
            <ul>
              <li><a href="./">Home</a></li>
              
              <li><a href="./#pop-art">Popular Articles</a></li>
              
               
              <li><a href="./#contact">Contacts</a></li>
              
            </ul>
          </nav>
        </div>
      </div>
    </div>

    
    <div class="container-block">
      <div class="header-content">
        <div class="main-news">
          <img src="assets/img/art_gallery_2025-02-02_00-420.webp" alt="" />
          <div class="main-news-text">
            <h5>Tech</h5>
            <h2>Exploring Modern Digital Landscapes</h2>
            <p>John Smith &#8226; 02.14.2025</p>
          </div>
        </div>
        <div class="news-box">
          <div class="news-card">
            <img src="assets/img/art_gallery_2025-02-02_00-421.webp" alt="" />
            <div class="news-card-text">
              <h5>Entertainment</h5>
              <h2>Navigating the Future of Online Trends</h2>
              <p>Mary Martin &#8226; 02.09.2025</p>
            </div>
          </div>
          <div class="news-card">
            <img src="assets/img/art_gallery_2025-02-02_00-422.webp" alt="" />
            <div class="news-card-text">
              <h5>Cars</h5>
              <h2>Unveiling Hidden Digital Strategies</h2>
              <p>Robert Johnson &#8226; 02.13.2025</p>
            </div>
          </div>
        </div>
      </div>
    </div>
    

    <script>
      document.addEventListener('DOMContentLoaded', function () {
        var header = document.querySelector('.header-lay');
        var headerHeight = header.offsetHeight;
        var scrollTrigger = 0.7 * window.innerHeight;

        window.addEventListener('scroll', function () {
          var scrollY = window.scrollY || window.pageYOffset;

          if (scrollY >= scrollTrigger) {
            header.classList.add('fixed-header');
            header.style.top = '0';
          } else {
            header.classList.remove('fixed-header');
            header.style.top = '-' + headerHeight + 'px';
          }
        });
      });
    </script>

    


<style>
	* {
		padding: 0;
		margin: 0;
	}
	#mainWrapp-search__labelum{
		margin: 0px;
		padding: 0px;
		font-family: 'Radio Canada Big', sans-serif;
		width: 100%;
		font-size: 17px;
		padding: 309px 0px;
	}
	.bodyClass1-search__labelum{
		background: #f6f4ec;
		color: #ffffff;
	}
	.bodyClass2-search__labelum{
		background: #fff;
		color: #fff;
	}
	.bodyClass3-search__labelum{
		background: #fff;
		color: #111;
	}
	.wrapage-block-search__labelum{
		background-size: 100%;
		width: 100%;
	}
	.box_main-search__labelum{
		width: 100%;
		margin: 0 auto;
		text-align: center;
		display: flex;
		justify-content: center;
		align-self: center;
		align-items: center;
	}
	.box_main-search__labelum h2{
		font-size: 24px;
		padding: 0px 0px 25px;
	}
	.box_main-search__labelum p{
		font-weight: 500;
		font-size: 18px;
	}
	p{
		margin-bottom: 10px;
	}
	.mainBlock-search__labelum{
		text-align: center;
	}
	.mainBlock-search__labelum ul{
		text-align: start;
		padding: 20px;
		display: flex;
		flex-direction: column;
		gap: 15px;
	}
	.mainBlock-search__labelum ul>li span{
		font-weight: bold;
	}
	.mainBlock-search__labelum{
		max-width: 945px;
		margin: 0 auto;
		padding: 40px;
		background: #7b7d008c;
		border-radius: 15px;
	}
	.mainBlock-search__labelum .cBlock-search__labelum{
		text-align: center;
	}

	.bodyClass3-search__labelum .mainBlock-search__labelum{
		background: none;
		border-top: 2px dotted #f0e4d7;
		border-bottom: 2px dotted #f0e4d7;
	}
	.bodyClass2-search__labelum .mainBlock-search__labelum{
		background: #220E24;
		color: #fff !important;
		box-shadow: 0px 0px 15px #220E24;
	}
	.bodyClass2-search__labelum .mainBlock-search__labelum p{
		color: #fff !important;
	}
	.bodyClass1-search__labelum .mainBlock-search__labelum{
		background: #243727;
		color: #ffffff;
		border-left: 5px solid #0A91AB;
	}
	.bodyClass1-search__labelum .mainBlock-search__labelum p{
		color: #ffffff !important;
	}
	.order-search__labelum{
		font-size: 19px !important;
	}

	  @media screen and (max-width: 639px) {
		  .box_main-search__labelum p{
			padding: 0px 15px;
		  }
		  .box_main-search__labelum h2{
			  padding: 0px 10px 15px;
		  }
		.mainBlock-search__labelum{
			padding: 15px;
		}


	}
	@media screen and (max-width: 480px) {
		#mainWrapp-search__labelum{
			height: 100%;
		}
	}
</style>
<div class="bodyClass2-search__labelum" id="mainWrapp-search__labelum">


	<div class="wrapage-block-search__labelum">
		<div class="box_main-search__labelum">
			<div class="mainBlock-search__labelum">
				<p>We're truly grateful for your outreach and the confidence you've placed in us. Your support empowers our dedicated team to enhance the caliber of our offerings continually.</p>
<p>Remember, your insights, feedback, and suggestions are invaluable to our growth and evolution. If there's anything on your mind or if you require assistance, please feel free to reach out. Our commitment is to be readily available to assist you.</p>
<p class="cBlock-search__labelum">With heartfelt thanks and warm wishes!</p>
			</div>
		</div>
	</div>


</div>




    <div class="footer-lay">
      <div class="container-block">
        <div class="footer reviewiz-link">
          <div class="footer-privacy">
            <div class="privacy">
              <a href="agreement.html">Privacy policy</a>
              <a href="terms-of-service.html">Terms & Conditions</a>
              <a href="disclaimer.html">Disclaimer</a>
            </div>
            <p>Copyright &#169; 2025 Stratexavc</p>
          </div>
        </div>
      </div>
    </div>

    <link rel="stylesheet" type="text/css" href="css/cookie.min.css">
<div id="data-notification"><p>We use cookies to improve your experience. By continuing to visit this site, you agree to our <a href="cookieUsage.html">Cookie Policy</a>.</p><span class="close">&times;</span></div>
<script src="js/cookie.min.js"></script> 

</body>
</html>
